{
  "slug":        "lockdown",
  "properties":  {
    "slug":                  "lockdown",
    "name":                  "WP Lockdown",
    "sidebar_name":          "Lockdown",
    "show_module_menu_item": false,
    "show_module_options":   true,
    "storage_key":           "lockdown",
    "tagline":               "Harden the more loosely controlled settings of your site",
    "show_central":          true,
    "access_restricted":     true,
    "premium":               false,
    "run_if_whitelisted":    false,
    "run_if_verified_bot":   false,
    "run_if_wpcli":          false,
    "order":                 90
  },
  "sections":    [
    {
      "primary":     true,
      "slug":        "section_apixml",
      "title":       "WordPress System Lockdown",
      "title_short": "System",
      "beacon_id":   413,
      "summary":     [
        "Purpose - Lockdown certain core WordPress system features.",
        "Recommendation - This depends on your usage and needs for certain WordPress functions and features."
      ]
    },
    {
      "slug":        "section_permission_access_options",
      "title":       "Permissions and Access Options",
      "title_short": "Permissions",
      "beacon_id":   415,
      "summary":     [
        "Purpose - Provides finer control of certain WordPress permissions.",
        "Recommendation - Only enable SSL if you have a valid certificate installed."
      ]
    },
    {
      "slug":        "section_wordpress_obscurity_options",
      "title":       "WordPress Obscurity Options",
      "title_short": "Obscurity",
      "beacon_id":   418,
      "summary":     [
        "Purpose - Obscures certain WordPress settings from public view.",
        "Recommendation - Obscurity is not true security and so these settings are down to your personal tastes."
      ]
    },
    {
      "slug":        "section_enable_plugin_feature_wordpress_lockdown",
      "title":       "Enable Module: Lockdown",
      "title_short": "Disable Module",
      "beacon_id":   272,
      "summary":     [
        "Purpose - Lockdown helps secure-up certain loosely-controlled WordPress settings on your site.",
        "Recommendation - Keep the Lockdown feature turned on."
      ]
    },
    {
      "slug":   "section_non_ui",
      "hidden": true
    }
  ],
  "options":     [
    {
      "key":         "enable_lockdown",
      "section":     "section_enable_plugin_feature_wordpress_lockdown",
      "advanced":    true,
      "default":     "Y",
      "type":        "checkbox",
      "link_info":   "https://shsec.io/4r",
      "link_blog":   "",
      "beacon_id":   272,
      "name":        "Enable Lockdown",
      "summary":     "Enable (or Disable) The Lockdown module",
      "description": "Un-Checking this option will completely disable the Lockdown module"
    },
    {
      "key":         "disable_xmlrpc",
      "section":     "section_apixml",
      "default":     "N",
      "type":        "checkbox",
      "link_info":   "https://shsec.io/e6",
      "link_blog":   "https://shsec.io/fb",
      "beacon_id":   414,
      "name":        "Disable XML-RPC",
      "summary":     "Disable The XML-RPC System",
      "description": "Checking this option will completely turn off the whole XML-RPC system."
    },
    {
      "key":         "disable_anonymous_restapi",
      "section":     "section_apixml",
      "advanced":    true,
      "default":     "N",
      "type":        "checkbox",
      "link_info":   "",
      "link_blog":   "",
      "name":        "Anonymous Rest API",
      "summary":     "Disable The Anonymous Rest API",
      "description": "Checking this option will completely turn off the whole Anonymous Rest API system."
    },
    {
      "key":         "api_namespace_exclusions",
      "section":     "section_non_ui",
      "default":     [
        "contact-form-7",
        "jetpack",
        "woocommerce"
      ],
      "type":        "array",
      "link_info":   "",
      "link_blog":   "",
      "name":        "Rest API Exclusions",
      "summary":     "Anonymous REST API Exclusions",
      "description": "Any namespaces provided here will be excluded from the Anonymous API restriction."
    },
    {
      "key":         "disable_file_editing",
      "section":     "section_permission_access_options",
      "default":     "N",
      "type":        "checkbox",
      "link_info":   "https://shsec.io/4q",
      "link_blog":   "https://shsec.io/hk",
      "beacon_id":   416,
      "name":        "Disable File Editing",
      "summary":     "Disable Ability To Edit Files From Within WordPress",
      "description": "Removes the option to directly edit any files from within the WordPress admin area. Equivalent to setting 'DISALLOW_FILE_EDIT' to TRUE."
    },
    {
      "key":         "force_ssl_admin",
      "section":     "section_permission_access_options",
      "default":     "N",
      "type":        "checkbox",
      "link_info":   "https://shsec.io/4t",
      "link_blog":   "",
      "beacon_id":   417,
      "name":        "Force SSL Admin",
      "summary":     "Forces WordPress Admin Dashboard To Be Delivered Over SSL",
      "description": "Please only enable this option if you have a valid SSL certificate installed. Equivalent to setting 'FORCE_SSL_ADMIN' to TRUE."
    },
    {
      "key":         "block_author_discovery",
      "section":     "section_wordpress_obscurity_options",
      "default":     "Y",
      "type":        "checkbox",
      "link_info":   "https://shsec.io/wpsf23",
      "link_blog":   "",
      "name":        "Block Username Fishing",
      "summary":     "Block the ability to discover WordPress usernames based on author IDs",
      "description": "When enabled, any URL requests containing 'author=' will be killed. Warning: Enabling this option may interfere with expected operations of your site."
    },
    {
      "key":         "clean_wp_rubbish",
      "section":     "section_wordpress_obscurity_options",
      "default":     "N",
      "type":        "checkbox",
      "link_info":   "",
      "link_blog":   "",
      "name":        "Clean WP Files",
      "summary":     "Automatically Delete Unnecessary WP Files",
      "description": "Automatically delete WordPress files like wp-config-sample.php."
    },
    {
      "key":         "hide_wordpress_generator_tag",
      "section":     "section_wordpress_obscurity_options",
      "default":     "N",
      "type":        "checkbox",
      "link_info":   "",
      "link_blog":   "",
      "name":        "WP Generator Tag",
      "summary":     "Remove WP Generator Meta Tag",
      "description": "Remove a meta tag from your WordPress pages that publicly displays that your site is WordPress and its current version."
    }
  ],
  "definitions": {
    "default_restapi_exclusions": [
      "contact-form-7",
      "jetpack",
      "tho",
      "wpstatistics",
      "woocommerce"
    ],
    "events":                     {
      "block_anonymous_restapi": {
        "recent": true
      },
      "block_xml":               {
        "audit":   false,
        "recent":  true,
        "offense": true
      }
    }
  }
}