<?php declare( strict_types=1 );

namespace FernleafSystems\Wordpress\Plugin\Shield\Tables\DataTables\Build\Scans;

use FernleafSystems\Wordpress\Plugin\Shield\Scans;

class ForMalware extends BaseForScan {

	protected function getColumnsToDisplay() :array {
		return [
			'rid',
			'file_as_href',
			'status',
			'fp_confidence',
			'line_numbers',
			'mal_sig',
			'detected',
			'actions',
		];
	}

	protected function getColumnDefs() :array {
		$colDefs = parent::getColumnDefs();
		$colDefs[ 'fp_confidence' ] = [
			'data'       => 'fp_confidence',
			'title'      => __( 'False Positive Confidence' ),
			'className'  => 'fp_confidence',
			'orderable'  => true,
			'searchable' => false,
			'visible'    => true,
		];
		$colDefs[ 'line_numbers' ] = [
			'data'       => 'line_numbers',
			'title'      => __( 'Line Numbers' ),
			'className'  => 'line_numbers',
			'orderable'  => false,
			'searchable' => false,
			'visible'    => true,
		];
		$colDefs[ 'mal_sig' ] = [
			'data'       => 'mal_sig',
			'title'      => __( 'Pattern Detected' ),
			'className'  => 'mal_sig',
			'orderable'  => false,
			'searchable' => true,
			'visible'    => true,
		];
		return $colDefs;
	}
}