<?php declare( strict_types=1 );

namespace FernleafSystems\Wordpress\Plugin\Core\Databases\Base\Traits;

use FernleafSystems\Wordpress\Plugin\Core\Utilities\Tool\IpListSort;

trait Select_IPTable {

	/**
	 * @return string[]
	 */
	public function getDistinctIps() :array {
		$ips = $this->getDistinctForColumn( 'ip' );
		if ( $this->getDbH()->getTableSchema()->is_ip_binary ) {
			$ips = array_map(
				function ( $binaryIP ) {
					return inet_ntop( $binaryIP );
				},
				$ips
			);
		}
		return IpListSort::Sort( $ips );
	}
}