{
  "slug":        "integrations",
  "properties":  {
    "slug":                  "integrations",
    "storage_key":           "integrations",
    "name":                  "Integrations",
    "menu_title":            "Integrations",
    "sidebar_name":          "Integrations",
    "show_module_options":   true,
    "show_module_menu_item": false,
    "auto_enabled":          false,
    "show_central":          true,
    "premium":               false,
    "access_restricted":     true,
    "run_if_whitelisted":    true,
    "run_if_wpcli":          true,
    "run_if_verified_bot":   true,
    "skip_processor":        false,
    "tracking_exclude":      false
  },
  "wpcli":       {
    "enabled": true
  },
  "sections":    [
    {
      "slug":        "section_integrations",
      "primary":     true,
      "title":       "Integrations",
      "title_short": "Integrations",
      "beacon_id":   404
    },
    {
      "slug":        "section_spam",
      "title":       "SPAM Detection",
      "title_short": "SPAM Detection",
      "beacon_id":   138
    },
    {
      "slug":        "section_user_forms",
      "title":       "User Forms Bot Detection",
      "title_short": "User Forms Bot Detection",
      "beacon_id":   239
    },
    {
      "slug":   "section_non_ui",
      "hidden": true
    }
  ],
  "options":     [
    {
      "key":         "enable_mainwp",
      "section":     "section_integrations",
      "default":     "Y",
      "type":        "checkbox",
      "link_info":   "https://shsec.io/ir",
      "link_blog":   "https://shsec.io/ke",
      "beacon_id":   404,
      "name":        "Enable MainWP",
      "summary":     "Enable The Built-In MainWP Extension",
      "description": "This option will enable Shield's built-in MainWP extension for both server and client."
    },
    {
      "key":           "form_spam_providers",
      "section":       "section_spam",
      "premium":       true,
      "advanced":      true,
      "type":          "multiple_select",
      "default":       [],
      "value_options": [
        {
          "value_key": "contactform7",
          "text":      "Contact Form 7"
        },
        {
          "value_key": "elementorpro",
          "text":      "Elementor Pro"
        },
        {
          "value_key": "fluentforms",
          "text":      "Fluent Forms"
        },
        {
          "value_key": "formidableforms",
          "text":      "Formidable Forms"
        },
        {
          "value_key": "forminator",
          "text":      "Forminator"
        },
        {
          "value_key": "gravityforms",
          "text":      "Gravity Forms"
        },
        {
          "value_key": "groundhogg",
          "text":      "Groundhogg"
        },
        {
          "value_key": "kaliforms",
          "text":      "Kali Forms"
        },
        {
          "value_key": "ninjaforms",
          "text":      "Ninja Forms"
        },
        {
          "value_key": "superforms",
          "text":      "Super Forms"
        },
        {
          "value_key": "supportcandy",
          "text":      "Support Candy"
        },
        {
          "value_key": "wpforo",
          "text":      "wpForo"
        },
        {
          "value_key": "wpforms",
          "text":      "WPForms"
        }
      ],
      "link_info":     "https://shsec.io/k2",
      "link_blog":     "https://shsec.io/k3",
      "beacon_id":     138,
      "name":          "SPAM Form Checking",
      "summary":       "Select The Form Providers That Should Be Checked For SPAM",
      "description":   "Select The Form Providers That Should Be Checked For SPAM."
    },
    {
      "key":           "user_form_providers",
      "section":       "section_user_forms",
      "premium":       true,
      "advanced":      true,
      "type":          "multiple_select",
      "default":       [
        "wordpress"
      ],
      "value_options": [
        {
          "value_key": "buddypress",
          "text":      "BuddyPress"
        },
        {
          "value_key": "easydigitaldownloads",
          "text":      "Easy Digital Downloads"
        },
        {
          "value_key": "learnpress",
          "text":      "LearnPress"
        },
        {
          "value_key": "lifterlms",
          "text":      "LifterLMS"
        },
        {
          "value_key": "memberpress",
          "text":      "MemberPress"
        },
        {
          "value_key": "paidmembersubscriptions",
          "text":      "Paid Member Subscriptions"
        },
        {
          "value_key": "profilebuilder",
          "text":      "Profile Builder"
        },
        {
          "value_key": "ultimatemember",
          "text":      "Ultimate Member"
        },
        {
          "value_key": "woocommerce",
          "text":      "WooCommerce"
        },
        {
          "value_key": "wordpress",
          "text":      "WordPress"
        },
        {
          "value_key": "wpmembers",
          "text":      "WP Members"
        }
      ],
      "link_info":     "https://shsec.io/k4",
      "link_blog":     "https://shsec.io/k3",
      "beacon_id":     239,
      "name":          "User Form Checking",
      "summary":       "Select The User Form Providers That Should Be Checked For SPAM Registrations and Logins",
      "description":   "Select The User Form Providers That Should Be Checked For SPAM Registrations and Logins"
    }
  ],
  "definitions": {
    "events": {
      "spam_form_pass":     {
        "stat":    true,
        "audit":   true,
        "offense": false
      },
      "spam_form_fail":     {
        "stat":    true,
        "audit":   true,
        "offense": false
      },
      "user_form_bot_pass": {
        "stat":    true,
        "audit":   true,
        "offense": false
      },
      "user_form_bot_fail": {
        "stat":    true,
        "audit":   true,
        "offense": true
      }
    }
  }
}