{
  "slug":             "traffic",
  "properties":       {
    "slug":                  "traffic",
    "name":                  "Traffic Watch",
    "sidebar_name":          "Traffic",
    "show_module_menu_item": false,
    "show_module_options":   true,
    "storage_key":           "traffic",
    "tagline":               "Watch All Requests To Your Site",
    "show_central":          true,
    "access_restricted":     true,
    "premium":               false,
    "run_if_whitelisted":    false,
    "run_if_verified_bot":   true,
    "run_if_wpcli":          false,
    "order":                 110
  },
  "menu_items":       [
    {
      "title": "Traffic Log",
      "slug":  "traffic-redirect"
    }
  ],
  "custom_redirects": [
    {
      "source_mod_page": "traffic-redirect",
      "target_mod_page": "insights",
      "query_args":      {
        "inav": "traffic"
      }
    }
  ],
  "sections":         [
    {
      "slug":        "section_traffic_options",
      "primary":     true,
      "title":       "Traffic Watch Options",
      "title_short": "Options",
      "beacon_id":   153,
      "summary":     [
        "Purpose - Provides finer control over the live traffic system.",
        "Recommendation - These settings are dependent on your requirements."
      ]
    },
    {
      "slug":        "section_traffic_limiter",
      "title":       "Traffic Rate Limiting",
      "title_short": "Rate Limiting",
      "beacon_id":   420,
      "summary":     [
        "Purpose - Provides ability to restrict excessive requests from a single visitor.",
        "Recommendation - These settings are dependent on your requirements."
      ]
    },
    {
      "slug":        "section_enable_plugin_feature_traffic",
      "title":       "Enable Module: Traffic Watch",
      "title_short": "Disable Module",
      "beacon_id":   153,
      "summary":     [
        "Purpose - The Traffic Watch module lets you monitor and review all requests to your site.",
        "Recommendation - Required only if you need to review and investigate and monitor requests to your site."
      ]
    },
    {
      "slug":   "section_non_ui",
      "hidden": true
    }
  ],
  "options":          [
    {
      "key":         "enable_traffic",
      "section":     "section_enable_plugin_feature_traffic",
      "advanced":    true,
      "default":     "Y",
      "type":        "checkbox",
      "link_info":   "https://shsec.io/ed",
      "link_blog":   "https://shsec.io/ee",
      "beacon_id":   153,
      "name":        "Enable Traffic Watch",
      "summary":     "Enable (or Disable) The Traffic Watch Module",
      "description": "Un-Checking this option will completely disable the Traffic Watch module."
    },
    {
      "key":         "enable_logger",
      "section":     "section_traffic_options",
      "default":     "N",
      "type":        "checkbox",
      "link_info":   "https://shsec.io/hf",
      "link_blog":   "",
      "beacon_id":   153,
      "name":        "Enable Traffic Logger",
      "summary":     "Turn On The Traffic Logging Feature",
      "description": "Enable or disable the ability to log and monitor requests to your site."
    },
    {
      "key":           "type_exclusions",
      "section":       "section_traffic_options",
      "type":          "multiple_select",
      "advanced":      true,
      "default":       [
        "logged_in",
        "cron",
        "search",
        "uptime"
      ],
      "value_options": [
        {
          "value_key": "simple",
          "text":      "Simple Requests"
        },
        {
          "value_key": "api",
          "text":      "REST API"
        },
        {
          "value_key": "ajax",
          "text":      "AJAX"
        },
        {
          "value_key": "logged_in",
          "text":      "Logged-In Users"
        },
        {
          "value_key": "cron",
          "text":      "WP CRON"
        },
        {
          "value_key": "search",
          "text":      "Search Engines"
        },
        {
          "value_key": "uptime",
          "text":      "Uptime Monitoring Services"
        }
      ],
      "link_info":     "https://shsec.io/eb",
      "link_blog":     "",
      "beacon_id":     154,
      "name":          "Traffic Log Exclusions",
      "summary":       "Select Which Types Of Requests To Exclude",
      "description":   "Deselect any requests that you don't want to appear in the traffic viewer."
    },
    {
      "key":         "custom_exclusions",
      "section":     "section_traffic_options",
      "advanced":    true,
      "premium":     true,
      "default":     [],
      "type":        "array",
      "link_info":   "https://shsec.io/ec",
      "link_blog":   "",
      "beacon_id":   154,
      "name":        "Custom Exclusions",
      "summary":     "Provide Custom Traffic Exclusions",
      "description": "For each entry, if the text is present in either the User Agent or Page/Path, it will be excluded."
    },
    {
      "key":         "auto_clean",
      "section":     "section_traffic_options",
      "advanced":    true,
      "default":     3,
      "min":         1,
      "type":        "integer",
      "link_info":   "",
      "link_blog":   "",
      "name":        "Auto Expiry Cleaning",
      "summary":     "Enable Traffic Log Auto Expiry",
      "description": "Automated DB cleanup will delete logs older than this maximum value (in days)."
    },
    {
      "key":         "max_entries",
      "section":     "section_traffic_options",
      "advanced":    true,
      "premium":     true,
      "default":     1000,
      "min":         0,
      "type":        "integer",
      "link_info":   "",
      "link_blog":   "",
      "name":        "Max Log Length",
      "summary":     "Maximum Traffic Log Length To Keep",
      "description": "Automated DB cleanup will delete logs to maintain this maximum number of records."
    },
    {
      "key":         "enable_limiter",
      "section":     "section_traffic_limiter",
      "premium":     true,
      "default":     "N",
      "type":        "checkbox",
      "link_info":   "https://shsec.io/gw",
      "link_blog":   "https://shsec.io/gx",
      "beacon_id":   420,
      "name":        "Enable Rate Limiting",
      "summary":     "Turn On The Rate Limiting Feature",
      "description": "Enable or disable the rate limiting feature according to your rate limiting parameters."
    },
    {
      "key":         "limit_requests",
      "section":     "section_traffic_limiter",
      "default":     "60",
      "min":         0,
      "type":        "integer",
      "link_info":   "",
      "link_blog":   "",
      "name":        "Max Request Limit",
      "summary":     "Maximum Number Of Requests Allowed In Time Limit",
      "description": "The maximum number of requests that are allowed in the given time limit."
    },
    {
      "key":         "limit_time_span",
      "section":     "section_traffic_limiter",
      "default":     "60",
      "min":         0,
      "type":        "integer",
      "link_info":   "",
      "link_blog":   "",
      "name":        "Request Limit Time Interval",
      "summary":     "The Time Interval To Test For Excessive Requests",
      "description": "The time limit within which to monitor for excessive requests that exceed the limit."
    }
  ],
  "definitions":      {
    "db_classes":         {
      "traffic": "\\FernleafSystems\\Wordpress\\Plugin\\Shield\\Databases\\Traffic\\Handler"
    },
    "db_table_traffic":   {
      "slug":        "traffic",
      "cols_custom": {
        "rid":   "varchar(10) NOT NULL DEFAULT '' COMMENT 'Request ID'",
        "uid":   "int(11) UNSIGNED NOT NULL DEFAULT 0 COMMENT 'User ID'",
        "ip":    "varbinary(16) DEFAULT NULL COMMENT 'Visitor IP Address'",
        "path":  "text NOT NULL DEFAULT '' COMMENT 'Request Path or URI'",
        "code":  "int(5) NOT NULL DEFAULT '200' COMMENT 'HTTP Response Code'",
        "verb":  "varchar(10) NOT NULL DEFAULT 'get' COMMENT 'HTTP Method'",
        "ua":    "text COMMENT 'Browser User Agent String'",
        "trans": "tinyint(1) UNSIGNED NOT NULL DEFAULT 0 COMMENT 'Trangression'"
      }
    },
    "traffic_table_name": "traffic",
    "events":             {
      "request_limit_exceeded": {
        "cat":     3,
        "offense": true
      }
    }
  }
}